c       evaluating black body radiation at a given temperature
c       numerical integration carried out using simpson's one-third rule
c
        implicit real*4(a-h,o-z)

c----------------------------------------------------
c       reading input
c
        write(*,*)'give a,b,n'
        read(*,*)a,b,n
        write(*,*)'give temperature'
        read(*,*)temp
c----------------------------------------------------
c       calculation of energy
c
c       prefactor
c
        pref=64.77/(temp**4)
c
c       evaluating the integral
c       
        h=(b-a)/(float(n))
        call getfunc(a,temp,fa)
        call getfunc(b,temp,fb)
        sum=fa+fb
        x=a

        do i=1,n-1
           x=x+h
           call getfunc(x,temp,fx)
           m=(i/2)*2
           if(m.eq.i)then
              ai=2.0
           else
              ai=4.0
           endif
           sum=sum+(ai*fx)
        end do

        value=(h*sum)/3.0
        write(*,*)'result of integration ',value
c
c       evaluating energy
c
        energy=pref*value
c
c--------------------------------------------------------------------
c       writing output
c
        write(*,*)'energy = ',energy
c--------------------------------------------------------------------
        stop
        end
c********************************************************************
        subroutine getfunc(q,temp,fq)
        implicit real*4(a-h,o-z)

        f1=1.432/(temp*q) 
        f1=exp(f1)-1.0
        f2=q**5
        fq=1.0/(f1*f2)
       
        write(15,*)q,temp,f1,f2,fq 

        return
        end

