c       evaluating specific heat of a solid at a given temperature
c       using Debye theory
c       numerical integration carried out using simpson's one-third rule
c
        implicit real*4(a-h,o-z)

c----------------------------------------------------
c       reading input
c
        write(*,*)'give a,n'
        read(*,*)a,n
        write(*,*)'give temperature'
        read(*,*)temp
c----------------------------------------------------
c       calculation
c
c       evaluation of the prefactor
c
        pi=4.0*atan(1.0)
        pi4=pi**4
        t3=temp**3
        pref=(3.0*pi4*t3)/5.0
c
c       evaluating the integral
c       
        b=1.0/temp
c
        h=(b-a)/(float(n))
        call getfunc(a,fa)
        call getfunc(b,fb)
        sum=fa+fb
        x=a

        do i=1,n-1
           x=x+h
           call getfunc(x,fx)
           m=(i/2)*2
           if(m.eq.i)then
              ai=2.0
           else
              ai=4.0
           endif
           sum=sum+(ai*fx)
        end do

        value=(h*sum)/3.0
        write(*,*)'result of integration ',value
c
c       evaluating specific heat
c
        cv=pref*value
c
c--------------------------------------------------------------------
c       writing output
c
        write(*,*)'specific heat= ',cv
c--------------------------------------------------------------------
        stop
        end
c********************************************************************
        subroutine getfunc(q,fq)
        implicit real*4(a-h,o-z)

        f1=(q**4)*exp(q)
        f2=exp(q)-1.0
        f2=f2*f2
        fq=f1/f2
       
        write(15,*)q,f1,f2,fq 

        return
        end

