c       evaluating specific heat of a solid at different temperatures
c       using Debye theory
c       numerical integration carried out using simpson's one-third rule
c
        implicit real*4(a-h,o-z)

c----------------------------------------------------
c       reading input
c
        write(*,*)'give initial temperatures'
        read(*,*)t0
        write(*,*)'give # of datapoints and interval of temperature'
        read(*,*)nt,delt
        write(*,*)'give # of intervals in integration'
        read(*,*)n
c----------------------------------------------------
        open(unit=16,file='debye.out',status='unknown')
c
        temp=t0
c
        do i=1,nt
           call debye(temp,n,cvt)
           write(16,77)temp,cvt
 77        format(f8.4,1x,e12.4)
           temp=temp+delt
        end do
        close(16)
c
        stop
        end 
c***************************************************************************
c       subroutine to calculate specific heat at a given temperature
c       using Debye theory
c
        subroutine debye(temp,n,cvt)
c
        implicit real*4 (a-h, o-z)
c
c       evaluation of the prefactor
c
        pi=4.0*atan(1.0)
        pi4=pi**4
        t3=temp**3
        pref=(3.0*pi4*t3)/5.0
c
c       evaluating the integral
c       
        a=1.e-04
        b=1.0/temp
        h=(b-a)/(float(n))
c
        call getfunc(a,fa)
        call getfunc(b,fb)
        sum=fa+fb
        x=a

        do i=1,n-1
           x=x+h
           call getfunc(x,fx)
           m=(i/2)*2
           if(m.eq.i)then
              ai=2.0
           else
              ai=4.0
           endif
           sum=sum+(ai*fx)
        end do

        value=(h*sum)/3.0
c
c       evaluating specific heat
c
        cvt=pref*value
c--------------------------------------------------------------------
        return
        end
c********************************************************************
        subroutine getfunc(q,fq)
        implicit real*4(a-h,o-z)

        f1=(q**4)*exp(q)
        f2=exp(q)-1.0
        f2=f2*f2
        fq=f1/f2
       
c       write(15,*)q,f1,f2,fq 

        return
        end

