c       solution of effusion of gas problem for a given time
c       x = time scaled by tau
c       y = pressure scaled by p0 (initial pressure)
c
c       numerical solution of first order ordinary differential equation
c       by 4th order Runge-Kutta method
c
c       solution for a given value of x
c
        implicit real*8 (a-h,o-z)
c
        open(unit=12,file='w6_3i.in',status='old')
        open(unit=14,file='w6_3i.out',status='unknown')
c
        read(12,*)x0,y0,xn,n
        close(12)
c       
        h=(xn-x0)/dfloat(n)
c
        xi=x0
        yi=y0
c
        do i=1,n
c
           call funxy(xi,yi,fxy1)
           xk1=h*fxy1
c
           xnew=xi+(0.5d0*h)
           y1new=yi+(0.5d0*xk1)
           call funxy(xnew,y1new,fxy2)
           xk2=h*fxy2
c
           y2new=yi+(0.5d0*xk2)
           call funxy(xnew,y2new,fxy3)
           xk3=h*fxy3
c
           xi=xi+h
           y3new=yi+h
           call funxy(xi,y3new,fxy4)
           xk4=h*fxy4
c
           dely=xk1+(2.d0*xk2)+(2.d0*xk3)+xk4
           dely=dely/6.d0
           yi=yi+dely
c
           call yideal(xi,yexact)
c
           write(14,88)xi,yi,yexact
   88      format(f12.4,2x,f12.4,2x,f12.4)
c
       end do
       close(14)
c
       stop
       end
c********************************************************
c      subroutine to evaluate the function of x and y on rhs
c
       subroutine funxy(x,y,fxy)
c
       implicit real*8(a-h,o-z)
c
       fxy=-y
c
       return
       end
c********************************************************
c      subroutine to evaluate the exact function y
c
       subroutine yideal(x,yid)
c
       implicit real*8(a-h,o-z)
c
       yid=exp(-x)
c
       return
       end
