c       numerical solution of van't Hoff equation for a range of
c       temperatures
c       x = T in Kelvin
c       y = ln K
c----------------------------------------------------------------------
c       numerical solution of first order ordinary differential equation
c       by 4th order Runge-Kutta method
c
c       program to obtain the values at a number of specified values of 
c       the independent parameter x
c----------------------------------------------------------------------
        implicit real*8 (a-h,o-z)
c
        parameter (rconst=8.314)
c
        open(unit=10,file='w6_4.in',status='old')
c
        read(10,*)nx,xnx
        read(10,*)x0,y0,n
        read(10,*)delh
        close(10)
c       
        y0=log(y0)
        write(*,*)'initial value of y =',y0
        delh=delh/rconst
        write(*,*)'delta H/R (1/K) =',delh
c
        open(unit=12,file='w6_4.out',status='unknown')
c
        hx=(xnx-x0)/float(nx)
c
        x=x0
        call yideal(x,x0,y0,delh,yexact)
        write(12,88)x0,y0,yexact
c
        do i=1,nx
c
           x=x+hx
           call rungekutta(x,x0,y0,n,delh,y)
           call yideal(x,x0,y0,delh,yexact)
           write(12,88)x,y,yexact
   88      format(3(f12.6,2x))
c
           x0=x
           y0=y
c
        end do
        close(12)
c
        stop
        end
c****************************************************************
        subroutine rungekutta(xn,x0,y0,n,delh,yn)
        implicit real*8 (a-h, o-z)
c
        h=(xn-x0)/dfloat(n)
c
        xi=x0
        yi=y0
c
        do i=1,n
c
           call funxy(xi,yi,delh,fxy1)
           xk1=h*fxy1
c
           xnew=xi+(0.5d0*h)
           y1new=yi+(0.5d0*xk1)
           call funxy(xnew,y1new,delh,fxy2)
           xk2=h*fxy2
c
           y2new=yi+(0.5d0*xk2)
           call funxy(xnew,y2new,delh,fxy3)
           xk3=h*fxy3
c
           xi=xi+h
           y3new=yi+h
           call funxy(xi,y3new,delh,fxy4)
           xk4=h*fxy4
c
           dely=xk1+(2.d0*xk2)+(2.d0*xk3)+xk4
           dely=dely/6.d0
           yi=yi+dely
c
       end do
       yn=yi
c
       return
       end
c********************************************************
c      subroutine to evaluate the function of x and y on rhs
c
       subroutine funxy(x,y,delh,fxy)
c
       implicit real*8(a-h,o-z)
c
       fxy=delh/(x*x)
c
       return
       end
c********************************************************
c      subroutine to evaluate the exact function y
c
       subroutine yideal(x,x0,y0,delh,yid)
c
       implicit real*8(a-h,o-z)
c
       dif=(1.0/x0)-(1.0/x)
       yid=y0+(delh*dif)
c
       return
       end
