c       program to solve a non-linear equation
c       using Newton-Raphson method
c
        implicit real*4 (a-h, o-z)
c
        open(unit=12,file='w7_2.in',status='old')
c
        read(12,*)x0,nt,delta
        close(12)
c
        x=x0
c
        do i=1,nt
c
           call getfunc(x,fx)
           call getderv(x,fpx)
c
           xnew=x-(fx/fpx)
c
           dif=abs(xnew-x)
c
           if(dif.le.delta) then
             write(*,*)'Convergence achieved'
             write(*,*)'Root =',xnew
             write(*,88)i,x,fx,fpx,xnew,dif
             stop
           endif
c
           write(*,88)i,x,fx,fpx,xnew,dif
 88        format(i4,5(e12.4,1x))
c
           x=xnew
c
        end do
c
        stop
        end
c***************************************************************
        subroutine getfunc(x,fx)
c
        implicit real*4 (a-h, o-z)
c
        fx=(x*x)-1.0
c
        return
        end
c***************************************************************
        subroutine getderv(x,fpx)
c
        implicit real*4 (a-h, o-z)
c
        fpx=2.d0*x
c
        return
        end
