c       program to calculate the bond angle
c
        implicit real*8 (a-h, o-z)
c
        dimension p(3),q(3),r(3)
        dimension pq(3),rq(3)
c
        open(unit=12,file='w8_2.in',status='old')
c
        read(12,*)(p(i),i=1,3)
        read(12,*)(q(i),i=1,3)
        read(12,*)(r(i),i=1,3)
        close(12)
c
c       calculating the components of pq and rq
c
        do i=1,3
           pq(i)=p(i)-q(i)
           rq(i)=r(i)-q(i)
        end do
c
c       calculating the lengths of pq and rq
c
        s1=0.d0
        s2=0.d0
        do i=1,3
           s1=s1+(pq(i)**2)  
           s2=s2+(rq(i)**2)  
        end do
        pql=dsqrt(s1)
        rql=dsqrt(s2)
c
c       calculating the scalar product of pq and rq
c
        scal=0.d0
        do i=1,3
           scal=scal+(pq(i)*rq(i))
        end do
c
c       calculating the bond angle
c
        xcos=scal/(pql*rql)
        theta=dacos(xcos)
c
        write(*,*)'bond angle (radian) =',theta
c
        pi=4.d0*datan(1.d0)
        theta2=(theta*180.d0)/pi
c
        write(*,*)'bond angle (degree) =',theta2
c
        stop
        end
        
